Imports System.Data.SqlClient

Module Module1
    Public Sub PrintTable(ByVal ds As DataSet)
        ' Afficher les rsultats de la table.
        Console.WriteLine("Voici ce que nous avons actuellement:")
        Dim invTable As DataTable = ds.Tables("Inventory")

        ' Afficher le nom des colonnes.
        Dim curCol As Integer
        For curCol = 0 To invTable.Columns.Count - 1
            Console.Write(invTable.Columns(curCol).ColumnName.Trim() & vbTab)
        Next
        Console.WriteLine()

        ' Afficher chaque cellule.
        Dim curRow As Integer
        For curRow = 0 To invTable.Rows.Count - 1
            For curCol = 0 To invTable.Columns.Count - 1
                Console.Write(invTable.Rows(curRow)(curCol).ToString().Trim() & vbTab)
            Next
            Console.WriteLine()
        Next
        Console.WriteLine()
    End Sub

    Sub Main()
        ' Etape 1: Crer une connexion et un adaptateur.
        Dim cn As SqlConnection = New SqlConnection("server=(local);uid=sa;pwd=;database=Cars;Integrated Security=SSPI")
        Dim dAdapt As SqlDataAdapter = New SqlDataAdapter("Select * from Inventory", cn)

        ' Etape 2: Etablir la commande UpdateCommand.
        dAdapt.UpdateCommand = New SqlCommand("UPDATE Inventory SET Make = @Make, Color = @Color, PetName = @PetName " & _
         "WHERE CarID = @CarID", cn)

        ' Etape 3: Crer les paramtres pour chaque colonne dans la table Inventory.
        Dim workParam As SqlParameter
        workParam = dAdapt.UpdateCommand.Parameters.Add(New SqlParameter("@CarID", SqlDbType.Int))
        workParam.SourceColumn = "CarID"
        workParam.SourceVersion = DataRowVersion.Current

        workParam = dAdapt.UpdateCommand.Parameters.Add(New SqlParameter("@Make", SqlDbType.VarChar))
        workParam.SourceColumn = "Make"
        workParam.SourceVersion = DataRowVersion.Current

        workParam = dAdapt.UpdateCommand.Parameters.Add(New SqlParameter("@Color", SqlDbType.VarChar))
        workParam.SourceColumn = "Color"
        workParam.SourceVersion = DataRowVersion.Current

        workParam = dAdapt.UpdateCommand.Parameters.Add(New SqlParameter("@PetName", SqlDbType.VarChar))
        workParam.SourceColumn = "PetName"
        workParam.SourceVersion = DataRowVersion.Current

        ' Etape 4: Remplir la table de donnes.
        Dim myDS As DataSet = New DataSet()
        dAdapt.Fill(myDS, "Inventory")
        PrintTable(myDS)

        ' Etape 5: Modifier la ligne.
        Dim changeRow As DataRow = myDS.Tables("Inventory").Rows(1)
        changeRow("Make") = "FooFoo"
        changeRow("Color") = "FooFoo"
        changeRow("PetName") = "FooFoo"

        ' Etape 6: Renvoyer  la base de donnes et afficher de nouveau les informations.
        Try

            dAdapt.Update(myDS, "Inventory")
            myDS.Dispose()
            myDS = New DataSet()
            dAdapt.Fill(myDS, "Inventory")
            PrintTable(myDS)
        Catch e As Exception

            Console.Write(e.ToString())
        End Try
    End Sub
End Module
